#pragma once 

#include <BWAPI.h>
#include "UnitZealotInterface.h"
#include <BWTA.h>


class UnitZealotManager
{
public: 
	UnitZealotManager() :target_region(nullptr), last_frame(0), flag_attack_retreat(false) {}; 

	void onFrame(); 
	void onUnitCreate(BWAPI::Unit u); 
	void onUnitDestory(BWAPI::Unit u); 
	void onEnd(); 

	void attack(); 
	void scout(); 

	BWTA::Region* getTargetRegion() { return target_region; }
	void setTargetRegion(BWTA::Region* r) { target_region = r; }

	UnitZealot getClosestUnit(BWAPI::Position p); 

	std::vector<UnitZealot> getUnitsInRadius(BWAPI::PositionOrUnit pu, int radius); 

	static UnitZealotManager& getInstance() { static UnitZealotManager uzm; return uzm; }; 


private:
	std::vector<UnitZealot>  units; 

	BWTA::Region* target_region; 

	int last_frame; 

	bool flag_attack_retreat; 

	std::vector<UnitZealot>::iterator getUnitIterator(BWAPI::Unit u); 

	BWAPI::PositionOrUnit getTarget(); 

	std::pair<double, double> getSelfWeaponAndHp(BWAPI::Position p); 

	std::pair<double, double> getTargetEnemyWeaponAndHp(BWAPI::Position p);
};